/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.general;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.language.VWLanguageElement;
import filenet.vw.toolkit.utils.uicontrols.language.VWLanguageList;
import filenet.vw.toolkit.utils.ws.base.IVWUDDIBusinessStatusListener;
import filenet.vw.toolkit.utils.ws.base.VWUDDIBusinessItem;
import filenet.vw.toolkit.utils.ws.base.VWUDDIBusinessStatusEvent;
import java.awt.Frame;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import org.apache.juddi.datatype.Description;

public class VWUDDIDescriptionTableModel
extends AbstractTableModel {
    protected static final int COLUMN_ID = 0;
    protected static final int COLUMN_DESCRIPTION = 1;
    protected static final int COLUMN_LANGUAGE = 2;
    protected Frame m_parentFrame = null;
    private Vector m_rowData = null;
    private boolean m_bHasChanged = false;
    private VWLanguageList m_languageList = new VWLanguageList();
    private Locale m_defaultLocale = Locale.getDefault();
    protected String[] m_columnNames = new String[]{"", VWResource.s_description, VWResource.s_language};
    private EventListenerList m_listenerList = null;
    private VWUDDIBusinessItem m_vwBusinessItem = null;
    private JComboBox m_languageTypeComboBox = null;

    public VWUDDIDescriptionTableModel(Frame parent, VWUDDIBusinessItem businessItem) {
        try {
            this.m_parentFrame = parent;
            this.m_vwBusinessItem = businessItem;
            if (this.m_vwBusinessItem != null) {
                this.m_rowData = this.m_vwBusinessItem.getDescriptionVector();
            }
            this.m_listenerList = new EventListenerList();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void resetData(Vector data) {
        this.m_rowData.clear();
        this.m_rowData = data;
    }

    public Vector getVector() {
        return this.m_rowData;
    }

    public void setDescriptionVector(Vector data) {
        this.m_rowData = data;
        this.fireTableDataChanged();
    }

    public void setBusinessEntity(VWUDDIBusinessItem businessItem) {
        try {
            this.m_vwBusinessItem = businessItem;
            if (this.m_vwBusinessItem != null) {
                this.m_rowData = this.m_vwBusinessItem.getDescriptionVector();
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Description getDescription(int rowIndex) {
        if (rowIndex < 0 || rowIndex > this.m_rowData.size()) {
            return null;
        }
        return (Description)this.m_rowData.elementAt(rowIndex);
    }

    public void setDescription(Description theDescription, int rowIndex) {
        if (rowIndex < 0 || rowIndex > this.m_rowData.size() || theDescription == null) {
            return;
        }
        this.m_rowData.setElementAt(theDescription, rowIndex);
        this.fireTableDataChanged();
        this.m_bHasChanged = true;
        if (this.m_vwBusinessItem != null) {
            this.m_vwBusinessItem.setModified(this.m_bHasChanged);
        }
        this.BusinessChanged(1);
    }

    public void addRow() {
        try {
            if (this.m_rowData == null) {
                this.m_rowData = new Vector();
            }
            Description desc = new Description();
            desc.setLanguageCode(this.m_defaultLocale.getLanguage());
            this.m_rowData.addElement(desc);
            int nRow = this.m_rowData.size() - 1;
            this.fireTableRowsInserted(nRow, nRow);
            this.m_bHasChanged = true;
            if (this.m_vwBusinessItem != null) {
                this.m_vwBusinessItem.setModified(this.m_bHasChanged);
            }
            this.BusinessChanged(1);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean hasChanged() {
        return this.m_bHasChanged;
    }

    public JComboBox getLanguageTypeComboBox() {
        try {
            if (this.m_languageTypeComboBox == null) {
                this.m_languageTypeComboBox = new JComboBox<VWLanguageElement>(this.m_languageList.getLanguageList());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_languageTypeComboBox;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: 
            case 1: {
                return String.class;
            }
            case 2: {
                return VWLanguageElement.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return this.m_columnNames.length;
    }

    public String getColumnName(int nColumn) {
        if (nColumn < 0 || nColumn > this.m_columnNames.length) {
            return null;
        }
        return this.m_columnNames[nColumn];
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            if (this.m_rowData == null) {
                return null;
            }
            Description oDescription = (Description)this.m_rowData.elementAt(nRowIndex);
            if (oDescription == null) {
                return null;
            }
            switch (nColumnIndex) {
                case 0: {
                    return String.valueOf(nRowIndex + 1);
                }
                case 1: {
                    String desc = oDescription.getValue();
                    if (desc == null) {
                        desc = "";
                    }
                    return desc;
                }
                case 2: {
                    String language = oDescription.getLanguageCode();
                    if (language == null || language.length() <= 0) {
                        oDescription.setLanguageCode(this.m_defaultLocale.getLanguage());
                        language = oDescription.getLanguageCode();
                    }
                    VWLanguageElement le = this.m_languageList.find(language, 1);
                    return le;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRow, int nColumn) {
        return nColumn != 0;
    }

    private int compareStrings(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return 0;
        }
        if (str1 == null && str2 != null) {
            return -1;
        }
        if (str1 != null && str2 == null) {
            return 1;
        }
        return str1.compareTo(str2);
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            if (this.m_rowData == null) {
                return;
            }
            Description oDescription = (Description)this.m_rowData.elementAt(nRowIndex);
            if (oDescription == null) {
                return;
            }
            switch (nColumnIndex) {
                case 0: {
                    break;
                }
                case 1: {
                    String newValue = (String)aValue;
                    String orgValue = oDescription.getValue();
                    if (this.compareStrings(newValue, orgValue) == 0) break;
                    oDescription.setValue((String)aValue);
                    this.m_bHasChanged = true;
                    if (this.m_vwBusinessItem != null) {
                        this.m_vwBusinessItem.setModified(this.m_bHasChanged);
                    }
                    this.BusinessChanged(1);
                    break;
                }
                case 2: {
                    String orgLanguage;
                    String language = null;
                    if (aValue != null) {
                        VWLanguageElement le;
                        if (aValue instanceof String) {
                            language = (String)aValue;
                            le = this.m_languageList.find(language, 0);
                            if (le != null) {
                                language = le.getCode();
                            }
                        } else if (aValue instanceof VWLanguageElement) {
                            le = (VWLanguageElement)aValue;
                            language = le.getCode();
                        }
                    }
                    if (this.compareStrings(language, orgLanguage = oDescription.getLanguageCode()) == 0) break;
                    oDescription.setLanguageCode(language);
                    this.m_bHasChanged = true;
                    if (this.m_vwBusinessItem != null) {
                        this.m_vwBusinessItem.setModified(this.m_bHasChanged);
                    }
                    this.BusinessChanged(1);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean verifyDescriptions() {
        boolean bSuccess = true;
        if (this.m_rowData != null) {
            int sz = this.m_rowData.size();
            block0: for (int i = 0; i < sz; ++i) {
                Description DescriptionItem = (Description)this.m_rowData.elementAt(i);
                String description = DescriptionItem.getValue();
                if (description == null || description.length() < 1) {
                    VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_noBusinessDescriptionOnRow.toString(String.valueOf(i + 1)), VWResource.s_errorMessage, 1);
                    bSuccess = false;
                    break;
                }
                String language = DescriptionItem.getLanguageCode();
                if (language == null || language.length() <= 0) {
                    DescriptionItem.setLanguageCode(this.m_defaultLocale.getLanguage());
                    language = DescriptionItem.getLanguageCode();
                }
                for (int j = i + 1; j < sz; ++j) {
                    Description targetItem = (Description)this.m_rowData.elementAt(j);
                    if (language.compareToIgnoreCase(targetItem.getLanguageCode()) != 0) continue;
                    VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_duplicateBusinessDescLanguageTypeInRow.toString(String.valueOf(i + 1), String.valueOf(j + 1)), VWResource.s_errorMessage, 1);
                    bSuccess = false;
                    continue block0;
                }
            }
        }
        return bSuccess;
    }

    public void releaseResources() {
        this.m_languageList.releaseResources();
        this.m_languageList = null;
        this.m_defaultLocale = null;
        this.m_columnNames = null;
        if (this.m_listenerList != null) {
            Object[] listeners = this.m_listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                this.m_listenerList.remove(IVWUDDIBusinessStatusListener.class, (IVWUDDIBusinessStatusListener)listeners[i + 1]);
                listeners[i] = null;
                listeners[i + 1] = null;
            }
            this.m_listenerList = null;
        }
    }

    public void up(int rowIndex) {
        try {
            if (rowIndex != 0) {
                Object currentObj = this.m_rowData.elementAt(rowIndex);
                Object previousObj = this.m_rowData.elementAt(rowIndex - 1);
                this.m_rowData.setElementAt(currentObj, rowIndex - 1);
                this.m_rowData.setElementAt(previousObj, rowIndex);
                this.m_bHasChanged = true;
                if (this.m_vwBusinessItem != null) {
                    this.m_vwBusinessItem.setModified(this.m_bHasChanged);
                }
                this.BusinessChanged(1);
                this.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void down(int rowIndex) {
        try {
            if (rowIndex < this.getRowCount() - 1) {
                Object currentObj = this.m_rowData.elementAt(rowIndex);
                Object previousObj = this.m_rowData.elementAt(rowIndex + 1);
                this.m_rowData.setElementAt(currentObj, rowIndex + 1);
                this.m_rowData.setElementAt(previousObj, rowIndex);
                this.m_bHasChanged = true;
                if (this.m_vwBusinessItem != null) {
                    this.m_vwBusinessItem.setModified(this.m_bHasChanged);
                }
                this.BusinessChanged(1);
                this.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeRow(int nRow) {
        try {
            if (this.m_rowData == null || nRow < 0 || nRow >= this.m_rowData.size()) {
                return;
            }
            Description rowItem = (Description)this.m_rowData.elementAt(nRow);
            if (rowItem != null) {
                this.m_rowData.removeElementAt(nRow);
                this.fireTableRowsDeleted(nRow, nRow);
                this.m_bHasChanged = true;
                if (this.m_vwBusinessItem != null) {
                    this.m_vwBusinessItem.setModified(this.m_bHasChanged);
                }
                this.BusinessChanged(1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void delete(int rowIndex) {
        try {
            if (rowIndex >= 0 && rowIndex < this.m_rowData.size()) {
                this.m_rowData.removeElementAt(rowIndex);
                this.fireTableRowsDeleted(rowIndex, rowIndex);
                this.m_bHasChanged = true;
                if (this.m_vwBusinessItem != null) {
                    this.m_vwBusinessItem.setModified(this.m_bHasChanged);
                }
                this.BusinessChanged(1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void addBusinessStatusListener(IVWUDDIBusinessStatusListener listener) {
        this.m_listenerList.add(IVWUDDIBusinessStatusListener.class, listener);
    }

    private void BusinessChanged(int evtType) {
        Object[] listeners = this.m_listenerList.getListenerList();
        VWUDDIBusinessStatusEvent evt = new VWUDDIBusinessStatusEvent(this, this.m_vwBusinessItem, evtType);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWUDDIBusinessStatusListener.class) continue;
            ((IVWUDDIBusinessStatusListener)listeners[i + 1]).businessChanged(evt);
        }
    }
}

